(function(exports) {
let interface_types = {ethernet: 0, master: 1, rs: 2, can: 3, rs_short: 4}
let tab_name = {0: 'Ethernet', 2: 'RS-485', 3: 'CAN', 4: 'RS-485'}

exports.show = function (device_model_param)
{
	let device_model_list = {
        0: [0, 2, 3],
        1: [0],
        2: [0, 2, 3],
        3: [0, 2, 3],
        4: [0, 2, 2],
        5: [0, 2, 2, 2, 3],
		55: [0, 2, 2, 2], //for special ETS without CAN
        6: [0, 2, 3, 3, 3],
		"old": [4, 3]
	}
	let tab_body = []
	let ul = $('<ul>')
	let table = $('<table>')

	let rs_is_one = true
	let can_is_one = true
	let rs_number = 0
	let can_number = 0
	for (tab_number in device_model_list[device_model_param])
	{
		let tab_type = device_model_list[device_model_param][tab_number]
		if (tab_type == interface_types.rs || tab_type == interface_types.rs_short) { rs_number++ }
		else if (tab_type == interface_types.can) { can_number++ }
		if (rs_number > 1) { rs_is_one = false }
		if (can_number > 1) { can_is_one = false }
	}

	rs_number = 0
	can_number = 0
	for (tab_number in device_model_list[device_model_param])
	{
		let tab_type = device_model_list[device_model_param][tab_number]

		if (tab_type == interface_types.ethernet)
		{
			ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`))
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_ip_address"), 0x2213, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_net_mask"), 0x2213, 3))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_gateway"), 0x2213, 4))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dns1"), 0x2213, 5))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dns2"), 0x2213, 6))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dhcp_enable"), 0x2213, 1))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Modbus TCP Slave"))))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("slave_enable"), 0x2343, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("slave_device_address"), 0x2343, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("slave_poll"), 0x2343, 5))
		}
		else if (tab_type == interface_types.rs || tab_type == interface_types.rs_short)
		{
			if (rs_is_one) { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`)) }
			else { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]} ${rs_number+1}</a></li>`)) }
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td')
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_enable"), 0x2143 + rs_number*4, 1).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_data_rate"), 0x2143 + rs_number*4, 2).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_parity"), 0x2143 + rs_number*4, 4).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_stop_bits"), 0x2143 + rs_number*4, 5).addClass('data_td'))
			tab_body[tab_number].append($('<tr>').addClass('table_header').addClass('data_td').append($('<td colspan="2">').text(l100n.localize_string("Modbus Settings"))))
			tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("rs_modbus_settings"))))
			if (tab_type == interface_types.rs)
			{
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_slave_enable"), 0x2323 + rs_number*4, 1).addClass('data_td'))
			}
			
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_device_address"), 0x2323 + rs_number*4, 2).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_answer_delay"), 0x2323 + rs_number*4, 3).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_poll_timeout"), 0x2323 + rs_number*4, 4).addClass('data_td'))
			if (tab_type == interface_types.rs)
			{
				tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("rs_master_settings"))))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_master_enable"), 0x2333 + rs_number*4, 1).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_startup_delay"), 0x2333 + rs_number*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_response_timeout"), 0x2333 + rs_number*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_interbyte_timeout"), 0x2333 + rs_number*4, 3).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_retry_count"), 0x2333 + rs_number*4, 5))
				tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("Modbus TCP GW Serial Settings"))))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_enable"), 0x2383 + rs_number*4, 1).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_start_addr"), 0x2383 + rs_number*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_end_addr"), 0x2383 + rs_number*4, 3).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_Address_Offset"), 0x2383 + rs_number*4, 4).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_Broadcast"), 0x2383 + rs_number*4, 5).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_ip_addr_number"), 0x2383 + rs_number*4, 6).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_ip_port"), 0x2383 + rs_number*4, 7).addClass('data_td'))
			}
			rs_number++
		}
		else if (tab_type == interface_types.can)
		{
			if (can_is_one) { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`)) }
			else { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]} ${can_number+1}</a></li>`)) }
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_enable"), 0x2103 + can_number*4, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_data_rate"), 0x2103 + can_number*4, 2))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("can_settings"))))
			for (i = 1; i <= configuration.can_nodes_count; ++i)
			{
				tab_body[tab_number].append(common.form_tag_tr(`${l100n.localize_string("node_id")} ${i}`, 0x2303 + can_number*4, i))
			}
			can_number++
		}
		else if (tab_type == interface_types.tcp_slave)
		{
		}

		table.append(tab_body[tab_number])
	}
	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	let board_head = $('<div>').append(l100n.localize_string("Network Settings")).addClass("accordion-header")
	let board_body = $('<div>').addClass("accordion-body").append(tabs_div)
	board_body.append('<br><a href="modbus_mappings_reader.html" target="_blank" id="Modbus_mappings">View "Modbus mappings"</a>')
	$("#network_settings").append(board_head).append(board_body)

	common.load_script('external/jquery.ipmask.js')
	.then(() => { $('.ip_addr').ipmask() })
}

})(this.network_settings = {})
